unit URechnen;

interface

uses StdCtrls, SysUtils, Dialogs;        // Includes

type TRechnung = Object
        private
           Edit1, Edit2, Edit3 : TEdit;               // Eingabefelder definiert
           Label1, Label2, Label3, Label4 : TLabel;
           Memo1 : TMemo;
           Richtig, Falsch: integer;         // Variablen definiert
           Ergebnis : integer;
           procedure addieren;                         // Rechenoperationen
           procedure subtrahieren;
           procedure multiplizieren;
           procedure dividieren;
        public
           Gesamt : integer;
           procedure create (E1, E2, E3 : TEdit;L1, L2, L3, L4 : TLabel;M : TMemo);  // initialisieren der Eingabefelder
           procedure run;            // Starten der Rechnungen
           procedure auswerten;      // Ergebnisse werden ausgewertet
     end;

implementation 

procedure TRechnung.create (E1, E2, E3 : TEdit;L1, L2, L3, L4  : TLabel;M : TMemo);
begin
     Edit1:=E1; Edit2:=E2; Edit3:=E3; Label1:=L1; Label2:=L2; Label3:=L3; Label4:=L4 ; Memo1:=M; // initilisieren der Eingabefelder
     Richtig:=0;Falsch:=0;Gesamt:=0;                                      // lschen
     Label2.Caption:='';Label3.Caption:='';Label4.Caption:='';            // lschen nach drcken des Start-Buttons
     randomize;                                                           // Zufallsgenerator
end;

procedure TRechnung.run;            
begin
     Edit3.Text := '';              // lscht das Ergebnisfeld
     case random(4)+1 of            // whlt Operation zufllig aus                           
        1: addieren;
        2: subtrahieren;
        3: multiplizieren;
        4: dividieren;
     end;
end;

procedure TRechnung.addieren;       // Addieren
var z1, z2 : integer;
begin
     z1:=random(101);               // Zufallszahlen zwischen 0 und 100
     z2:=random(101);
     Ergebnis := z1+z2;
     Edit1.Text:=inttostr(z1);      // Umwandeln Integer to Zeichenkette
     Edit2.Text:=inttostr(z2);
     Label1.Caption:='+';
end;

procedure TRechnung.subtrahieren;    // Subtrahieren
var z1, z2 : integer;
begin
     z1:=random(101);
     z2:=random(101);
     Ergebnis := z1-z2;
     Edit1.Text:=inttostr(z1);
     Edit2.Text:=inttostr(z2);
     Label1.Caption:='-';
end;

procedure TRechnung.multiplizieren;       // Multiplizieren
var z1, z2 : integer;
begin
     z1:=random(21);
     z2:=random(21);
     Ergebnis := z1*z2;
     Edit1.Text:=inttostr(z1);
     Edit2.Text:=inttostr(z2);
     Label1.Caption:='*';
end;

procedure TRechnung.dividieren;             // Dividieren
var z1, z2 : integer;
begin
     z1:=random(100)+1;
     repeat                         // Repeat-Schleife wird mindestens 1mal durchlaufen
        z2:=random(51);
     until (z2<>0);                // keine Division durch 0
     z1:=z1-(z1 mod z2);           // Division ohne Rest
     Ergebnis := z1 div z2;        // ganzzahlige Division
     Edit1.Text:=inttostr(z1);
     Edit2.Text:=inttostr(z2);
     Label1.Caption:=':';
end;

procedure TRechnung.auswerten;         // Berechnungsvorgang
begin
     try
     inc(Gesamt);
     if strtoint(Edit3.Text) = Ergebnis then begin
        inc(Richtig);
        Memo1.Lines.Add('Rechnung ' + inttostr(Gesamt)+ ': Richtig! (' + Edit1.Text + Label1.Caption + Edit2.Text + '=' + inttostr(Ergebnis) + ')');
     end else begin
         inc(Falsch);
         Memo1.Lines.Add('Rechnung ' + inttostr(Gesamt)+ ': Falsch! (' + Edit1.Text + Label1.Caption + Edit2.Text + '=' + inttostr(Ergebnis) + ')');
     end;

     Label3.Caption:= inttostr(Richtig) + ' = ' + floattostr (round(Richtig/Gesamt*10000)/100) + '%';
     Label4.Caption:= inttostr(Falsch) + ' = ' + floattostr (round(Falsch/Gesamt*10000)/100) + '%';
     Label2.Caption:= inttostr(Gesamt);
     except
           showmessage('Falsche Eingabe');                     // Bei Eingabe von Buchstaben, Sonderzeichen oder gar keiner Eingabe -> Fehlermeldung wird angezeigt
           dec(Gesamt);
     end;
end;

end.
